/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.text;

import org.hamcrest.AbstractMatcherTest;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsNot;
import org.hamcrest.text.IsEqualIgnoringCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsEqualIgnoringCaseTest
extends AbstractMatcherTest {
    @Override
    protected Matcher<?> createMatcher() {
        return IsEqualIgnoringCase.equalToIgnoringCase((String)"irrelevant");
    }

    public void testIgnoresCaseOfCharsInString() {
        MatcherAssert.assertThat((Object)"HELLO", (Matcher)IsEqualIgnoringCase.equalToIgnoringCase((String)"heLLo"));
        MatcherAssert.assertThat((Object)"hello", (Matcher)IsEqualIgnoringCase.equalToIgnoringCase((String)"heLLo"));
        MatcherAssert.assertThat((Object)"HelLo", (Matcher)IsEqualIgnoringCase.equalToIgnoringCase((String)"heLLo"));
        MatcherAssert.assertThat((Object)"bye", (Matcher)IsNot.not((Matcher)IsEqualIgnoringCase.equalToIgnoringCase((String)"heLLo")));
    }

    public void testFailsIfAdditionalWhitespaceIsPresent() {
        MatcherAssert.assertThat((Object)"heLLo ", (Matcher)IsNot.not((Matcher)IsEqualIgnoringCase.equalToIgnoringCase((String)"heLLo")));
        MatcherAssert.assertThat((Object)" heLLo", (Matcher)IsNot.not((Matcher)IsEqualIgnoringCase.equalToIgnoringCase((String)"heLLo")));
    }

    public void testFailsIfMatchingAgainstNull() {
        MatcherAssert.assertThat(null, (Matcher)IsNot.not((Matcher)IsEqualIgnoringCase.equalToIgnoringCase((String)"heLLo")));
    }

    public void testRequiresNonNullStringToBeConstructed() {
        try {
            IsEqualIgnoringCase.equalToIgnoringCase(null);
            IsEqualIgnoringCaseTest.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testDescribesItselfAsCaseInsensitive() {
        IsEqualIgnoringCaseTest.assertDescription("equalToIgnoringCase(\"heLLo\")", IsEqualIgnoringCase.equalToIgnoringCase((String)"heLLo"));
    }
}

